<# :
@echo off
setlocal
cd /d "%~dp0"
openfiles >nul 2>&1
if %errorlevel% neq 0 (
    powershell -Command "Start-Process -FilePath '%0' -Verb RunAs"
    exit /b
)
powershell -NoProfile -ExecutionPolicy Bypass -Command "iex ((Get-Content -LiteralPath '%~f0') -join \"`n\")"
pause
exit /b
#>

# --- DÉBUT DU SCRIPT DE NETTOYAGE POWERSHELL ---
Write-Host "--- Nettoyage approfondi de GigaTribe ---" -ForegroundColor Cyan

#
# 1. Terminer les processus actifs
#
Write-Host "Fermeture de toute instance GigaTribe en cours d'exécution" -ForegroundColor Cyan
Stop-Process -Name "GigaTribe" -Force -ErrorAction SilentlyContinue
$processName = "GigaTribe"
Get-Process | Where-Object { $_.Name -like "*$processName*" } | Stop-Process -Force -ErrorAction SilentlyContinue

#
# 2. Identifier les dossiers d'installation
#
$possibleInstallDirs = @("${env:ProgramFiles(x86)}\GigaTribe", "$env:ProgramFiles\GigaTribe")

#
# 3. Gérer la désinstallation (QTIFW récent ou Inno Setup ancien) — essayer les deux emplacements d'installation
#
foreach ($installDir in $possibleInstallDirs) {
    if (Test-Path $installDir) {
        if (Test-Path "$installDir\maintenancetool.exe") {
            Write-Host "Version récente détectée (Qt Framework) dans $installDir. Exécution de l'outil de maintenance..." -ForegroundColor Cyan
            # --confirm-command purge est la commande de désinstallation silencieuse pour QTIFW
            Start-Process -FilePath "$installDir\maintenancetool.exe" -ArgumentList "--confirm-command purge" -Wait
        }
        elseif (Test-Path "$installDir\unins000.exe") {
            Write-Host "Version plus ancienne détectée (Inno Setup) dans $installDir. Exécution du programme de désinstallation..." -ForegroundColor Cyan
            Start-Process -FilePath "$installDir\unins000.exe" -ArgumentList "/VERYSILENT /SUPPRESSMSGBOXES" -Wait
        }
        else {
            Write-Host "Aucun désinstalleur trouvé dans $installDir. Tentative de suppression manuelle plus tard." -ForegroundColor Yellow
        }
    }
}

#
# 4. Analyseur dynamique du Registre (trouve GUIDs et Qt MaintenanceTool)
#
$UninstallHives = @(
    "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall",
    "HKLM:\SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall",
    "HKCU:\Software\Microsoft\Windows\CurrentVersion\Uninstall"
)
foreach ($Hive in $UninstallHives) {
    if (Test-Path $Hive) {
        Get-ChildItem -Path $Hive | ForEach-Object {
            $prop = Get-ItemProperty $_.PSPath -ErrorAction SilentlyContinue
            if ($prop.DisplayName -like "*GigaTribe*") {
                Write-Host "Trouvé : $($prop.DisplayName)" -ForegroundColor Yellow
                if ($prop.UninstallString -like "*maintenancetool*") {
                    $cleanPath = $prop.UninstallString -replace '"', ''
                    Start-Process -FilePath $cleanPath -ArgumentList "--confirm-command purge" -Wait -NoNewWindow -ErrorAction SilentlyContinue
                }
                Remove-Item -Path $_.PSPath -Recurse -Force -ErrorAction SilentlyContinue
            }
        }
    }
}

#
# 5. Nettoyer les clés de registre
#
$RegKeys = @(
    "HKCU:\Software\Shalsoft",
    "HKCU:\Software\Shalit",
    "HKLM:\SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\GigaTribe",
    "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\GigaTribe_is1"
)
foreach ($key in $RegKeys) {
    if (Test-Path $key) {
        Remove-Item -Path $key -Recurse -Force
        Write-Host "Clé de registre supprimée : $key" -ForegroundColor Yellow
    }
}

#
# 6. Dossiers ciblés système & AppData
#
$Folders = @(
    "${env:ProgramFiles}\GigaTribe",
    "${env:ProgramFiles(x86)}\GigaTribe",
    "$env:AppData\GigaTribe",
    "$env:LocalAppData\Shalsoft",
    "$env:LocalAppData\GigaTribe"
)
foreach ($Path in $Folders) {
    if (Test-Path $Path) {
        Remove-Item -Path $Path -Recurse -Force -ErrorAction SilentlyContinue
        Write-Host "Dossier supprimé : $Path" -ForegroundColor Yellow
    }
}

#
# 7. Nettoyer les téléchargements partiels dans le dossier "Documents" localisé
# Cela trouve le chemin 'Documents' même s'il a été renommé ou déplacé sur un autre lecteur
#
$docsPath = [Environment]::GetFolderPath("MyDocuments")
if (Test-Path $docsPath) {
    Write-Host "Recherche des dossiers de téléchargement GigaTribe dans : $docsPath" -ForegroundColor Cyan
    # Recherche de tout répertoire dans Documents contenant "GigaTribe"
    $gtFolders = Get-ChildItem -Path $docsPath -Directory -Filter "*GigaTribe*" -ErrorAction SilentlyContinue
    
    foreach ($dir in $gtFolders) {
        Write-Host "Suppression des fichiers partiels dans : $($dir.Name)" -ForegroundColor Yellow
        Get-ChildItem -Path $dir.FullName -Include "*.downloading", "*.downloading.state" -Recurse -File -ErrorAction SilentlyContinue | Remove-Item -Force
    }
}

#
# 8. Supprimer les règles du pare-feu
#
Write-Host "Suppression des règles du pare-feu..." -ForegroundColor Gray
netsh advfirewall firewall delete rule name="GigaTribe" > $null

Write-Host "`nNettoyage terminé ! Prêt pour un nouveau départ." -ForegroundColor Green
Write-Host "`nhttps://www.gigatribe.com/" -ForegroundColor Blue